<?php 

    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/?alias=linee-guida-per-luso-del-logo-geecom
    */
?>
    <h4 class="mb-4 title">Impostazioni</h4>
   
    <form name="formDatiBlog" class="form-horizontal" role="form" name="formDatiBlog" action="../../../controller/ecommerce/controllerImpostazioni.php" method="post" >
        <input class="d-none" name="operazione" value="modificaImpostazioniGenerali">
        
        <div class="row mt-5">
            <div class="col-12">
                <h5>Impostazioni generali</h5>
                <hr>
            </div>
            
            <div class="col-md-3 form-group">
                <label class="d-block">Usa il sito come catalogo</label>
                <input type="checkbox" class="js-switch" name="bloccaAcquisti"  value="si" <?= ($impostazioniEcommerce["bloccaAcquisti"]=="si") ? "checked":"" ?>>
                <small class="text-muted d-block">Attivando questa opzione gli utenti non potranno effettuare acquisti</small>
            </div>
            
            <div class="col-md-3 form-group">
                <label for="">Email recezione ordini</label>
                <input type="text" class="form-control" min="1" name="mailOrdini" value="<?= $impostazioniEcommerce["mailOrdini"] ?>" step="1">										
            </div>
            
            <div class="col-xl-3">
                <div class="form-group">
                    <label for="paginaAcquistoNonEffettuato">Pagina acquisto non effettuato</label>
                    <select class="form-control" id="paginaAcquistoNonEffettuato" name="paginaAcquistoNonEffettuato">
                  	<option value="0">Non impostata</option>
                  	<?php 
                          $queryPagine  = "SELECT * FROM geecB_contenuti WHERE tipo LIKE 'pagina' AND linguaContenuto LIKE 'italiano'";
                          $risContenuti = $geecomDb->eseguiQueryLettura($queryPagine);
                          while($contenuto = $risContenuti->fetch_assoc()) {
                              if($impostazioniEcommerce["paginaAcquistoNonEffettuato"]==$contenuto["id"]) {
                              	echo"<option value=\"{$contenuto["id"]}\" selected>{$contenuto["titolo"]}</option>";						
                              }
                              else {
                              	echo"<option value=\"{$contenuto["id"]}\">{$contenuto["titolo"]}</option>";
                              }
                          }
                  	?>
                    </select>
                    <small class="text-muted">Se impostata gli utenti verranno rediretti in questa pagina quando il pagamento non va a buon fine</small>
                </div>
            </div>
        </div>

        <div class="row mt-5">
            <div class="col-12">                
                <h5>Pagina prodotto</h5>
                <hr>
            </div>
            
            <div class="col-md-3 form-group">
                <label class="d-block">Mostra selettore quantità</label>
                <input type="checkbox" class="js-switch" name="mostraSelettoreQuantita"  value="si" <?= ($impostazioniEcommerce["mostraSelettoreQuantita"]=="si") ? "checked":"" ?>>
                <small class="text-muted d-block">Se disattivato gli utenti potranno acquistare una unità di ciascun prodotto per ogni ordine </small>
            </div>
            
            <div class="col-md-3 form-group">
                <label class="d-block">Mostra quantità rimanenti</label>
                <input type="checkbox" class="js-switch" name="mostraPezziRimanenti"  value="si" <?= ($impostazioniEcommerce["mostraPezziRimanenti"]=="si") ? "checked":"" ?>>
                <small class="text-muted d-block">Se attivato verrà mostrata la quantità rimanente di ogni prodotto</small>
            </div>

            <div class="col-md-3 form-group">
                <label class="d-block">Mostra EAN</label>
                <input type="checkbox" class="js-switch" name="mostraEanPaginaProdotto"  value="si" <?= ($impostazioniEcommerce["mostraEanPaginaProdotto"]=="si") ? "checked":"" ?>>
                <small class="text-muted d-block">Se attivato verrà mostrato l'EAN di ogni prodotto</small>
            </div>
            
            <div class="w-100"></div>
                        
            <div class="col-md-3 form-group">
                <label class="d-block">Attiva raccomandazione prodotti</label>
                <input type="checkbox" class="js-switch" name="attivaRaccomandazioneProdotti"  value="si" <?= ($impostazioniEcommerce["attivaRaccomandazioneProdotti"]=="si") ? "checked":"" ?>>
                <small class="text-muted d-block">Sotto ogni prodotto verranno mostrati prodotti simili</small>
            </div>
            
            <div class="col-md-3 form-group">
                <label for="">Prodotti raccomandati da mostrare</label>
                <input type="number" class="form-control" min="1" name="numeroProdottiRaccomandatiDaMostrare" value="<?= $impostazioniEcommerce["numeroProdottiRaccomandatiDaMostrare"]; ?>" step="1">
                <small class="text-muted d-block">Il numero di prodotti raccomandati da visualizzare</small>
            </div>
        </div>
        
        <div class="row mt-5">
            <div class="col-12">                
                <h5>Pagina carrello</h5>
                <hr>
            </div>
            
            <div class="col-md-3 form-group">
                <label class="d-block">Registrazione obbligatoria</label>
                <input type="checkbox" class="js-switch" name="registrazioneObbligatoria"  value="si" <?= ($impostazioniEcommerce["registrazioneObbligatoria"]=="si") ? "checked":"" ?>>
                <small class="text-muted d-block">Se attivato non sarà possibile completare un acquisto senza registrazione </small>
            </div>
            
            <div class="col-md-3 form-group">
                <label class="d-block">Richiedi password</label>
                <input type="checkbox" class="js-switch" name="richiediPassword"  value="si" <?= ($impostazioniEcommerce["richiediPassword"]=="si") ? "checked":"" ?>>
                <small class="text-muted d-block">Se attivo nella pagina carrello verrà richiesta la password insieme agli altri dati di registrazione</small>
            </div>
            
            <div class="col-md-3 form-group">
                <label class="d-block">Nascondi metodi spedizione</label>
                <input type="checkbox" class="js-switch" name="nascondiDivSpedizione"  value="si" <?= ($impostazioniEcommerce["nascondiDivSpedizione"]=="si") ? "checked":"" ?>>
                <small class="text-muted d-block">Se attivo non verranno mostrati metodi di spedizione. Consigliabile solo se è presente la spedizione gratuita</small>
            </div>
        </div>
        
        <div class="row mt-5">
            <div class="col-12">
                <h5>Tasse</h5>
                <hr>
            </div>
            
            <div class="col-md-3 form-group">
                <label class="d-block">Aggiungi IVA ai prodotti</label>
                <input type="checkbox" class="js-switch" name="aggiungiIvaProdotti"  value="si" <?= ($impostazioniEcommerce["aggiungiIvaProdotti"]=="si") ? "checked":"" ?>>
                <small class="text-muted d-block">Se attivo verrà aggiunto il costo dell'iva a ogni prodotto</small>
            </div>
            
            <div class="col-md-3 form-group">
                <label for="">Valore predefinito IVA</label>
                <input type="number" class="form-control" min="1" name="valorePredefinitoIva" value="<?= $impostazioniEcommerce["valorePredefinitoIva"] ?>" step="1">
                <small class="text-muted d-block">Il valore predefinito che verrà impostato quando viene creato un nuovo prodotto</small>
            </div>
            
            <div class="col-md-3 form-group">
                <label for="">Mostra prezzi negozio</label>
                <select class="form-control" name="mostraIvaPrezziNegozio">
                    <?php 
                        $opzioniIva = array("IVA inclusa","IVA esclusa");
                        foreach($opzioniIva as $opzione) {
                            if($opzione==$impostazioniEcommerce["mostraIvaPrezziNegozio"]) {
                                echo"<option value=\"{$opzione}\" SELECTED>{$opzione}</option>";						
                            }
                            else {
                                echo"<option value=\"{$opzione}\">{$opzione}</option>";
                            }
                        }
                    ?>
                </select>
                <small class="text-muted d-block">Scegli come mostrare i prezzi nelle schede prodotto e nella ricerca</small>
            </div>
            
            <div class="col-md-3 form-group">
                <label for="">Mostra prezzi carrello</label>
                <select class="form-control" name="mostraIvaPrezziCarrello">
                    <?php 
                        foreach($opzioniIva as $opzione) {
                            if($opzione==$impostazioniEcommerce["mostraIvaPrezziCarrello"]) {
                                echo"<option value=\"{$opzione}\" SELECTED>{$opzione}</option>";						
                            }
                            else {
                                echo"<option value=\"{$opzione}\">{$opzione}</option>";
                            }
                        }
                    ?>
                </select>
                <small class="text-muted d-block">Scegli come mostrare i prezzi nella pagina del carrello</small>
            </div>
        </div>
        
        <div class="row mt-5">
            <div class="col-12">
                <h5>Fatturazione</h5>
                <hr>
            </div>
            
            <div class="col-md-3 form-group">
                <label for="">Documento fatturazione</label>
                <select class="form-control" name="documentoFiscale">
                    <?php 
                        $dimenisioniSingoloArticolo = array("nessuno","fattura","ricevuta");
                        foreach($dimenisioniSingoloArticolo as $tipoDocumento) {
                            if($dimensione==$impostazioniEcommerce["documentoFiscale"]) {
                                echo"<option value=\"{$tipoDocumento}\" SELECTED>{$tipoDocumento}</option>";						
                            }
                            else {
                                echo"<option value=\"{$tipoDocumento}\">{$tipoDocumento}</option>";
                            }
                        }
                    ?>
                </select>
                <small class="form-text text-muted">Seleziona il tipo di documento di fatturazione</small>
            </div>
            
            <div class="col-md-3 form-group">
                <label for="">Prefisso documento fatturazione</label>
                <input type="text" class="form-control" min="1" name="prefissoDocumentoFiscale" value="<?php  echo $impostazioniEcommerce["prefissoDocumentoFiscale"]; ?>" step="1">										
            </div>
        </div>
    </form>
    <button type="button" onclick="document.formDatiBlog.submit()" class="btn btn-primary float-right"><i class="fas fa-check"></i> Salva</button>
